/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client;

import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.profiler.crash.CrashHandler;
import com.terraforged.mod.profiler.crash.CrashReportBuilder;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.world.chunk.IChunk;

public class ClientCrashHandler
implements CrashHandler {
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crash(IChunk chunk, TFChunkGenerator generator, Throwable t) {
        long stamp = this.lock.tryWriteLock();
        if (!this.lock.validate(stamp)) {
            return;
        }
        try {
            ThreadPools.shutdownAll();
            CrashReport report = CrashReportBuilder.buildCrashReport(chunk, generator, t);
            ClientCrashHandler.displayCrashReport(report);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private static void displayCrashReport(CrashReport report) {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a((String)report.func_71502_e());
        if (report.func_71497_f() != null) {
            Bootstrap.func_179870_a((String)("#@!@# Game crashed! Crash report saved to: #@!@# " + report.func_71497_f()));
            Runtime.getRuntime().halt(-1);
        } else if (report.func_147149_a(file2)) {
            Bootstrap.func_179870_a((String)("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath()));
            Runtime.getRuntime().halt(-1);
        } else {
            Bootstrap.func_179870_a((String)"#@?@# Game crashed! Crash report could not be saved. #@?@#");
            Runtime.getRuntime().halt(-2);
        }
    }
}

